
<?php $__env->startSection('style'); ?>
    <link href="<?php echo e(asset('public/assets/plugins/select2/css/select2.min.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('public/assets/plugins/select2/css/select2-bootstrap4.css')); ?>" rel="stylesheet" />
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<!--start breadcrumb-->
<div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
    <div class="breadcrumb-title pe-3">Events</div>
    <div class="ps-3">
      <nav aria-label="breadcrumb">
        <ol class="breadcrumb mb-0 p-0 align-items-center">
          <li class="breadcrumb-item"><a href="javascript:;"><ion-icon name="home-outline"></ion-icon></a>
          </li>
          <li class="breadcrumb-item active" aria-current="page">Add New Events</li>
        </ol>
      </nav>
    </div>
    <div class="ms-auto">
      <div class="btn-group">
        <a href="<?php echo e(route('events.index')); ?>" class="btn btn-outline-primary">Back to List</a>
      </div>
    </div>
  </div>
  <!--end breadcrumb-->


  <div class="row">
    <div class="col-xl-12">
        <?php if(Session::has('success')): ?>
        <div class="alert alert-success">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <?php echo e(Session::get('success')); ?>

            <?php
                Session::forget('success');
            ?>
        </div>
        <?php elseif(Session::has('error')): ?>
        <div class="alert alert-danger">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <?php echo e(Session::get('error')); ?>

            <?php
                Session::forget('error');
            ?>
        </div>
        <?php endif; ?>
      <div class="card">
        <div class="card-body">
          <div class="border p-3 rounded">
          <h6 class="mb-0 text-uppercase">Add New Event</h6>
          <hr>
          <?php echo Form::open(array('route' => 'events.store','method'=>'POST', 'enctype'=> 'multipart/form-data' , 'class'=> 'row g-3')); ?>

            
            <div class="col-12">
                <label class="form-label">Name</label>
                <input type="text" class="form-control" name="name" value="<?php echo e(old('name')); ?>">
                <?php if($errors->has('name')): ?>
                    <span class="text-danger"><?php echo e($errors->first('name')); ?></span>
                <?php endif; ?>
            </div>
            
            <div class="col-12">
              <label class="form-label">Description</label>
              <textarea class="form-control" name="description"><?php echo e(old('description')); ?></textarea>
                <?php if($errors->has('description')): ?>
                    <span class="text-danger"><?php echo e($errors->first('description')); ?></span>
                <?php endif; ?>
            </div>
            
            <div class="col-6">
              <label class="form-label">Featured Image</label>
              <input type="file" class="form-control" name="featured_image">
               
            </div>
            <div class="col-6">
                <label class="form-label">Is Exclusive?</label>
                <div class="form-check">
									<input class="form-check-input" type="checkbox" value="yes" id="flexCheckDefault" name="is_exclusive">
									<label class="form-check-label" for="flexCheckDefault">Exclusive</label>
								</div>
              </div>
            <div class="col-12">
              <div class="d-grid">
                <button type="submit" class="btn btn-primary">Save</button>
              </div>
            </div>
          <?php echo Form::close(); ?>

        </div>
        </div>
      </div>
    </div>
  </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script src="<?php echo e(asset('public/assets/plugins/select2/js/select2.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/assets/js/form-select2.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/blogxonf/public_html/resources/views/admin/pages/events/add-event.blade.php ENDPATH**/ ?>