
<?php $__env->startSection('style'); ?>
    <link href="<?php echo e(asset('public/assets/plugins/select2/css/select2.min.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('public/assets/plugins/select2/css/select2-bootstrap4.css')); ?>" rel="stylesheet" />
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<!--start breadcrumb-->
<div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
    <div class="breadcrumb-title pe-3">Stores</div>
    <div class="ps-3">
      <nav aria-label="breadcrumb">
        <ol class="breadcrumb mb-0 p-0 align-items-center">
          <li class="breadcrumb-item"><a href="javascript:;"><ion-icon name="home-outline"></ion-icon></a>
          </li>
          <li class="breadcrumb-item active" aria-current="page">Add New Store</li>
        </ol>
      </nav>
    </div>
    <div class="ms-auto">
      <div class="btn-group">
        <a href="<?php echo e(route('stores.index')); ?>" class="btn btn-outline-primary">Back to List</a>
      </div>
    </div>
  </div>
  <!--end breadcrumb-->


  <div class="row">
    <div class="col-xl-12">
        <?php if(Session::has('success')): ?>
        <div class="alert alert-success">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <?php echo e(Session::get('success')); ?>

            <?php
                Session::forget('success');
            ?>
        </div>
        <?php elseif(Session::has('error')): ?>
        <div class="alert alert-danger">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <?php echo e(Session::get('error')); ?>

            <?php
                Session::forget('error');
            ?>
        </div>
        <?php endif; ?>
      <div class="card">
        <div class="card-body">
          <div class="border p-3 rounded">
          <h6 class="mb-0 text-uppercase">Add New Store</h6>
          <hr>
          <?php echo Form::open(array('route' => 'stores.store','method'=>'POST', 'enctype'=> 'multipart/form-data' , 'class'=> 'row g-3')); ?>

            <div class="col-6">
              <label class="form-label">Category</label>
              <select class="single-select " name="category_id">
                <option value="">--select Category--</option>
                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option  value="<?php echo e($row->id); ?>"><?php echo e($row->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </select>
            </div>
            <div class="col-6">
              <label class="form-label">Event</label>
              <select class="single-select " name="event_id">
                <option value="">--select Event--</option>
                <?php $__currentLoopData = $events; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option  value="<?php echo e($row->id); ?>"><?php echo e($row->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </select>
            </div>
            <div class="col-12">
                <label class="form-label">Name</label>
                <input type="text" class="form-control" name="name" value="<?php echo e(old('name')); ?>">
                <?php if($errors->has('name')): ?>
                    <span class="text-danger"><?php echo e($errors->first('name')); ?></span>
                <?php endif; ?>
            </div>
            <div class="col-12">
              <label class="form-label">Url</label>
              <input type="text" class="form-control" name="url" value="">
            </div>
            <div class="col-12">
              <label class="form-label">Description</label>
              <textarea class="form-control" name="description"><?php echo e(old('description')); ?></textarea>
                <?php if($errors->has('description')): ?>
                    <span class="text-danger"><?php echo e($errors->first('description')); ?></span>
                <?php endif; ?>
            </div>
            <div class="col-12">
              <label class="form-label">Blog Description</label>
              <textarea class="form-control" name="blog_description"><?php echo e(old('blog_description')); ?></textarea>
                <?php if($errors->has('blog_description')): ?>
                    <span class="text-danger"><?php echo e($errors->first('blog_description')); ?></span>
                <?php endif; ?>
            </div>
            <div class="col-12">
              <label class="form-label">Meta Title</label>
              <input type="text" class="form-control" name="meta_title" value="<?php echo e(old('meta_title')); ?>">
                <?php if($errors->has('meta_title')): ?>
                    <span class="text-danger"><?php echo e($errors->first('meta_title')); ?></span>
                <?php endif; ?>
            </div>
            <div class="col-12">
              <label class="form-label">Meta Description</label>
              <textarea class="form-control" name="meta_description"><?php echo e(old('meta_description')); ?></textarea>
                <?php if($errors->has('meta_description')): ?>
                    <span class="text-danger"><?php echo e($errors->first('meta_description')); ?></span>
                <?php endif; ?>
            </div>
            <div class="col-12">
              <label class="form-label">Featured Image</label>
              <input type="file" class="form-control" name="featured_image">
               
            </div>
            <div class="col-12">
              <div class="d-grid">
                <button type="submit" class="btn btn-primary">Save</button>
              </div>
            </div>
          <?php echo Form::close(); ?>

        </div>
        </div>
      </div>
    </div>
  </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script src="<?php echo e(asset('public/assets/plugins/select2/js/select2.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/assets/js/form-select2.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/helprfbn/majesticblogs.com/resources/views/admin/pages/stores/add-store.blade.php ENDPATH**/ ?>