
<?php $__env->startSection('style'); ?>
    <link href="<?php echo e(asset('public/assets/plugins/datatable/css/dataTables.bootstrap5.min.css')); ?>" rel="stylesheet" />
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>


<!--start breadcrumb-->
<div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
    <div class="breadcrumb-title pe-3">Users</div>
    <div class="ps-3">
      <nav aria-label="breadcrumb">
        <ol class="breadcrumb mb-0 p-0 align-items-center">
          <li class="breadcrumb-item"><a href="javascript:;"><ion-icon name="home-outline"></ion-icon></a>
          </li>
          <li class="breadcrumb-item active" aria-current="page">Users Record</li>
        </ol>
      </nav>
    </div>
    <div class="ms-auto">
        <div class="btn-group">
          <a href="<?php echo e(route('users.create')); ?>" class="btn btn-outline-primary">Add New User</a>
        </div>
      </div>
  </div>
  <!--end breadcrumb-->
        
        <div class="card">
            <div class="card-body">
                <div class="table-responsive">
                    <table id="example2" class="table table-striped table-bordered">
                        <thead>
                            <tr>
                                <th>Name</th>
                                <th>Email</th>
                                <th>Role</th>
                                <th>Status</th>
                                <th>Created_at</th>
                                <?php if(session()->get('role') != 'editor'): ?>
                                
                                <th>Actions</th>
                                <?php endif; ?>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($row->name); ?></td>
                                    <td><?php echo e($row->email); ?></td>
                                    <td><?php echo e($row->role); ?></td>
                                    <td><?php if($row->status == 'active'): ?> <span class="badge bg-success"> Active</span> <?php else: ?> <span class="badge bg-danger"> In Active </span> <?php endif; ?></td>
                                   
                                    <td><?php echo e(date('d-M-Y',strtotime($row->created_at))); ?></td>
                                    <?php if(session()->get('role') != 'editor'): ?>
                                    
                                    <td>
                                        <a href="<?php echo e(route('users.edit',$row->id)); ?>" class="text-warning btn btn-default" data-bs-toggle="tooltip" data-bs-placement="bottom" title="" data-bs-original-title="Edit info" aria-label="Edit">
                                            <ion-icon name="pencil-sharp" role="img" class="md hydrated" aria-label="pencil sharp"></ion-icon>
                                          </a>
                                          <a href="<?php echo e(route('change.password',$row->id)); ?>" class="text-warning btn btn-default" data-bs-toggle="tooltip" data-bs-placement="bottom" title="" data-bs-original-title="Change Password" aria-label="Change Password">
                                            <ion-icon name="key" role="img" class="md hydrated" aria-label="Change Password "></ion-icon>
                                          </a>
                                    <?php echo Form::open(['method' => 'DELETE','route' => ['users.destroy', $row->id],'style'=>'display:inline']); ?>

                                        <?php echo Form::button('<ion-icon name="trash-sharp" role="img" class="md hydrated" aria-label="trash sharp"></ion-icon>', ['type' =>'submit', 'class'=> 'btn btn-default text-danger' ,'data-bs-toggle'=>'tooltip', 'data-bs-placement'=>'bottom' , 'data-bs-original-title'=>'Delete', 'aria-label'=>'Delete']); ?>

                                    <?php echo Form::close(); ?>

                                    </td>
                                    <?php endif; ?>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                        
                    </table>
                </div>
            </div>
        </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>

<script src="<?php echo e(asset('public/assets/plugins/datatable/js/jquery.dataTables.min.js')); ?>"></script>
<script src="<?php echo e(asset('public/assets/plugins/datatable/js/dataTables.bootstrap5.min.js')); ?>"></script>
<script src="<?php echo e(asset('public/assets/js/table-datatable.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\akodracoupons\resources\views/admin/pages/users/users-list.blade.php ENDPATH**/ ?>