<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\CategoryController;
use App\Http\Controllers\Admin\SettingController;
use App\Http\Controllers\Admin\BannerController;
use App\Http\Controllers\Admin\CouponController;
use App\Http\Controllers\Admin\AdminController;
use App\Http\Controllers\Admin\StoreController;
use App\Http\Controllers\Admin\EventController;
use App\Http\Controllers\Admin\PageController;
use App\Http\Controllers\Admin\BlogController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Auth\AuthController;
use App\Http\Controllers\Home\HomeController;


/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/


Route::group(['prefix'=>'auth'],function(){
    Route::get('/login',[AuthController::class,'LoginView'])->name('login.view');
    Route::post('/login-validate',[AuthController::class,'ValidateLogin'])->name('login.validate');
    Route::get('/logout',[AuthController::class,'Logout'])->name('logout');
    Route::get('/change-password/{id}',[AuthController::class,'ChangePassword'])->name('change.password');
    Route::post('/update-password',[AuthController::class,'UpdatePassword'])->name('update.password');
});
Route::group(['prefix'=>'admin','middleware'=>'login'],function(){
    Route::get('/',[AdminController::class,'index'])->name('index');
    Route::resource('users', UserController::class);
    Route::resource('banners', BannerController::class);
    Route::resource('categories', CategoryController::class);
    Route::resource('stores', StoreController::class);
    Route::resource('coupons', CouponController::class);
    Route::resource('blogs', BlogController::class);
    Route::resource('pages', PageController::class);
    Route::resource('events', EventController::class);
    Route::get('/store-coupons/{id}',[StoreController::class,'coupons'])->name('store_coupon');
    Route::get('/update-order',[StoreController::class,'update_order'])->name('update_order');
    Route::get('site-content',[SettingController::class,'Sitecontent'])->name('site.content');
    Route::post('store-content',[SettingController::class,'storeSiteContent'])->name('store.content');
    Route::post('update-content',[SettingController::class,'updateSiteContent'])->name('update.content');
    Route::get('general-settings',[SettingController::class,'generalSetting'])->name('general.settings');
    Route::post('store-general-settings',[SettingController::class,'storeSetting'])->name('store.general.settings');
    Route::post('update-general-settings',[SettingController::class,'updateSetting'])->name('update.general.settings');
    Route::get('theme-settings',[SettingController::class,'themeSetting'])->name('theme.settings');
    Route::post('store-theme-settings',[SettingController::class,'storethemeSetting'])->name('store.theme.settings');
    Route::post('update-theme-settings',[SettingController::class,'updatethemeSetting'])->name('update.theme.settings');
    Route::get('query-settings',[SettingController::class,'querySetting'])->name('query.settings');
    Route::post('store-query-settings',[SettingController::class,'storequerySetting'])->name('store.query.settings');
    Route::post('update-query-settings',[SettingController::class,'updatequerySetting'])->name('update.query.settings');
    Route::get('add-social-media',[SettingController::class,'AddSocialMedia'])->name('add.social.media');
    Route::get('social-media',[SettingController::class,'SocialMedia'])->name('social.media');
    Route::post('store-social-media',[SettingController::class,'storeSocialMedia'])->name('store.social.media');
    Route::get('edit-social-media/{id}',[SettingController::class,'EditSocialMedia'])->name('social.media.edit');
    Route::get('del-social-media/{id}',[SettingController::class,'DelSocialMedia'])->name('social.media.destroy');
    Route::post('update-social-media',[SettingController::class,'updateSocialMedia'])->name('update.social.media');
});

Route::get('/',[HomeController::class,'index'])->name('frontend-index');
Route::get('/merchants',[HomeController::class,'stores'])->name('frontend-stores');
Route::get('/merchants/{slug}',[HomeController::class,'StoreProfile'])->name('store.profile');
Route::get('/categories',[HomeController::class,'categories'])->name('frontend-categories');
Route::get('/category/{slug}',[HomeController::class,'categoryProfile'])->name('category.profile');
Route::get('/blogs',[HomeController::class,'blogs'])->name('frontend-blogs');
Route::get('/blog/{slug}',[HomeController::class,'blogProfile'])->name('blog.profile');
Route::get('blog-category/{slug}',[HomeController::class,'BlogsbyCategory'])->name('blogs.category');
Route::get('info/{slug}',[HomeController::class,'Page'])->name('page');
Route::get('/get-stores',[HomeController::class,'getstores'])->name('get-stores');
Route::get('/get-blogs',[HomeController::class,'getblogs'])->name('get-blogs');
Route::get('/update_coupon_used',[HomeController::class,'update_coupon_used'])->name('update_coupon_used');
Route::get('/search-stores',[HomeController::class,'search_stores'])->name('search_stores');