
@extends('user.layout.master')
@section('meta-content')
    @php
        $settings = \App\Models\GeneralSetting::find(1);
    @endphp
    <meta name="csrf-token" content="{{ csrf_token() }}" />
    <meta name="title" content="@if ($settings) {{ $settings->meta_title }} @endif">
    <meta name="description" content="@if ($settings) {{ $settings->meta_description }} @endif">
    <meta name="tags" content="@if ($settings) {{ $settings->meta_tags }} @endif">
    <meta name="keywords" content="@if ($settings) {{ $settings->meta_keywords }} @endif">
    <link rel="canonical" href="{{ url('/') }}" />
@endsection
@section('styles')
  
@endsection
@section('content')
<section class="popular_categories">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="main_heading">
                    <h4><span>All Stores</span></h4>
                </div>
                <div class="p_c_wrapper">
                    <div class="p_c_main">
                        @foreach ($stores as $row)
                            <a href="{{ route('store.profile', $row->slug) }}" class="p_cat_item">
                                <figure class="p_c_img overlay">
                                    <img class="lazy"
                                        data-src="{{ asset('public/assets/images/stores') }}/{{ $row->feature_image }}">
                                </figure>
                                <div class="p_c_hover_icon flex_center">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                        viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                        stroke-linecap="round" stroke-linejoin="round">
                                        <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                        <path d="M5 12l14 0"></path>
                                        <path d="M13 18l6 -6"></path>
                                        <path d="M13 6l6 6"></path>
                                    </svg>
                                </div>
                                <content class="p_c_content">
                                    <h4 class="webkit_box">{{ $row->name }}</h4>

                                </content>
                            </a>
                        @endforeach
                    </div>
                    @php
                    $query = \App\Models\QuerySetting::find(1);
                    @endphp
                    @if ($query->storepage_stores == 'paginate()')
                    {{ $stores->links('pagination::bootstrap-4') }}
                    @endif
                </div>
                
            </div>
          
        </div>
    </div>
</section>

@endsection