@extends('user.layout.master')
@section('meta-content')
    @php
        $settings = \App\Models\GeneralSetting::find(1);
    @endphp
    <meta name="csrf-token" content="{{ csrf_token() }}" />
    <meta name="title" content="@if ($settings) {{ $settings->meta_title }} @endif">
    <meta name="description" content="@if ($settings) {{ $settings->meta_description }} @endif">
    <meta name="tags" content="@if ($settings) {{ $settings->meta_tags }} @endif">
    <meta name="keywords" content="@if ($settings) {{ $settings->meta_keywords }} @endif">
    <link rel="canonical" href="{{ url('/') }}" />
@endsection
@section('content')
    <section class="hero">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <h2 class="hero_heading">Guidelines for Saving Money When Shopping Online.</h2>
                    <div class="hero_main flex_align_start  gap_30">
                        <div class="hero_slider swiper">
                            <div class="swiper-wrapper">
                                @foreach ($latestblogs as $lblog)
                                    <div class="swiper-slide">
                                        <a href="{{ route('blog.profile', $lblog->slug) }}" class="hero_swiper_slide">
                                            <figure class="hero_swiper_img">
                                                <img
                                                    src="{{ asset('public/assets/images/blogs') }}/{{ $lblog->feature_image }}">
                                            </figure>
                                            <content class="hero_swiper_content">

                                                <h4 class="hero_slide_heading blog_title webkit_box">{{ $lblog->title }}
                                                </h4>
                                                <h4 class="hero_slide_desc blog_desc webkit_box">
                                                </h4>
                                                <div class="author_n_views">
                                                    <div class="blog_tags">
                                                        <div class="tag">{{ $lblog->category }}</div>
                                                    </div>

                                                </div>
                                            </content>
                                        </a>
                                    </div>
                                @endforeach
                            </div>
                            <div class="swiper-button-next arrows"></div>
                            <div class="swiper-button-prev arrows"></div>
                        </div>
                        <div class="hero_content">
                              @foreach ($featuredblogs as $fblog)
                                <a href="{{ route('blog.profile', $fblog->slug) }}" class="blog layout_2">
                                    <figure>
                                        <div class="blog_tags">
                                            <div class="tag">{{ $fblog->category }}</div>
                                        </div>
                                        <img class="lazy"
                                            data-src="{{ asset('public/assets/images/blogs') }}/{{ $fblog->feature_image }}">
                                    </figure>
                                    <content>

                                        <h4 class="webkit_box">{{ $fblog->title }}</h4>
                                        <p class="webkit_box">
                                          <div style="
                                          overflow: hidden;
                                          text-overflow: ellipsis;display: -webkit-box;
                                           -webkit-line-clamp: 2;
                                           -webkit-box-orient: vertical;">{!!$fblog->description!!}</div>
                                        </p>

                                    
                                    </content>
                                 </a>
                              @endforeach
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="popular_blogs">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="main_heading">
                        <h4><span>Featured Posts</span></h4>
                    </div>
                    <div class="p_b_main">
                        @foreach ($popularblogs as $pblog)
                            <a href="{{ route('blog.profile', $pblog->slug) }}" class="p_b_blog">
                                <figure class="p_b_img">
                                    <img class="lazy"
                                        data-src="{{ asset('public/assets/images/blogs') }}/{{ $pblog->feature_image }}">
                                    <div class="blog_tags">
                                        <div class="tag">{{ $pblog->category }}</div>
                                    </div>
                                </figure>
                                <content class="p_b_content">
                                    <h4 class="blog_title webkit_box">{{ $pblog->title }}</h4>
                                    <p class="blog_desc webkit_box p_b_desc">
                                       
                                    </p>

                                </content>
                            </a>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </section>






    <section class="popular_categories">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="main_heading">
                        <h4><span>popular categories</span></h4>
                    </div>
                    <div class="p_c_wrapper">
                        <div class="p_c_main">
                            @foreach ($categories as $row)
                                <a href="{{ route('blogs.category', $row->slug) }}" class="p_cat_item">
                                    <figure class="p_c_img overlay">
                                        <img class="lazy"
                                            data-src="{{ asset('public/assets/images/categories') }}/{{ $row->logo_image }}">
                                    </figure>
                                    <div class="p_c_hover_icon flex_center">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                            viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                            stroke-linecap="round" stroke-linejoin="round">
                                            <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                            <path d="M5 12l14 0"></path>
                                            <path d="M13 18l6 -6"></path>
                                            <path d="M13 6l6 6"></path>
                                        </svg>
                                    </div>
                                    <content class="p_c_content">
                                        <h4 class="webkit_box">{{ $row->name }}</h4>

                                    </content>
                                </a>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
