
@extends('user.layout.master')
@section('meta-content')
@php
$settings = \App\Models\GeneralSetting::find(1);
@endphp
<meta name="csrf-token" content="{{csrf_token()}}" />
<meta name="title" content="@if($settings){{$settings->meta_title}}@endif">
<meta name="description" content="@if($settings){{$settings->meta_description}}@endif">
<meta name="tags" content="@if($settings){{$settings->meta_tags}}@endif">
<meta name="keywords" content="@if($settings){{$settings->meta_keywords}}@endif">
<link rel="canonical" href="{{url('/')}}"/>
@endsection
@section('content')
<section class="single_post">
   <div class="container">
      <div class="row">
         <div class="col-12">
            <div class="s_p_main">
               <div class="s_p_wrapper">
                  <div class="s_p_img">
                     <div class="s_p_img_wrapper">
                        <div class="main_post_title">
                           <h2 class="blog_main_title">{{$blog->title}}</h2>
                        </div>
                     </div>
                     <figure>
                        <img class="lazy"
                           data-src="{{ asset('public/assets/images/blogs') }}/{{ $blog->feature_image }}">
                     </figure>
                    
                  </div>
                  <div class="post_content">
                    {!!$blog->description!!}
                  </div>
                  
               </div>
               <div class="s_p_sidebar">

                  <div class="s_p_item">
                     <h4 class="ftr_heading">Latest Articles</h4>
                     <div class="ftr_column_item">
                        @foreach ($popularblogs as $pblog)
                        <a href="{{ route('blog.profile', $pblog->slug) }}"
                           class="blog layout_2">
                           <figure>
                              <img data-src="{{ asset('public/assets/images/blogs') }}/{{ $pblog->feature_image }}"
                                 class="lazy" />
                           </figure>
                           <content>
                              <h4 class="webkit_box">{{$pblog->title}}</h4>

                              
                           </content>
                        </a>
                        @endforeach
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </div>
</section>


@endsection