
@extends('admin.layout.master')
@section('style')
    <link href="{{ asset('public/assets/plugins/select2/css/select2.min.css') }}" rel="stylesheet" />
    <link href="{{ asset('public/assets/plugins/select2/css/select2-bootstrap4.css') }}" rel="stylesheet" />
@endsection
@section('content')

<!--start breadcrumb-->
<div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
    <div class="breadcrumb-title pe-3">Stores</div>
    <div class="ps-3">
      <nav aria-label="breadcrumb">
        <ol class="breadcrumb mb-0 p-0 align-items-center">
          <li class="breadcrumb-item"><a href="javascript:;"><ion-icon name="home-outline"></ion-icon></a>
          </li>
          <li class="breadcrumb-item active" aria-current="page">Edit Store</li>
        </ol>
      </nav>
    </div>
    <div class="ms-auto">
      <div class="btn-group">
        <a href="{{route('stores.index')}}" class="btn btn-outline-primary">Back to List</a>
      </div>
    </div>
  </div>
  <!--end breadcrumb-->


  <div class="row">
    <div class="col-xl-12">
        @if(Session::has('success'))
        <div class="alert alert-success">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            {{ Session::get('success') }}
            @php
                Session::forget('success');
            @endphp
        </div>
        @elseif(Session::has('error'))
        <div class="alert alert-danger">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            {{ Session::get('error') }}
            @php
                Session::forget('error');
            @endphp
        </div>
        @endif
      <div class="card">
        <div class="card-body">
          <div class="border p-3 rounded">
          <h6 class="mb-0 text-uppercase">Edit Store</h6>
          <hr>
          {!! Form::model($store, ['method' => 'PATCH','route' => ['stores.update', $store->id] , 'enctype'=> 'multipart/form-data','class' => 'row g-3']) !!}
          <div class="col-6">
            <label class="form-label">Category</label>
            <select class="single-select " name="category_id">
              <option value="{{$store->category_id}}">{{$store->category}}</option>
              <option value="">--select Category--</option>
              @foreach ($categories as $key => $row)
                  <option  value="{{ $row->id }}">{{ $row->name}}</option>
              @endforeach
          </select>
          </div>
          <div class="col-6">
            <label class="form-label">Event</label>
            <select class="single-select " name="event_id">
              <option value="{{$store->event_id}}">{{$store->event}}</option>
              <option value="">--select Event--</option>
              @foreach ($events as $key => $row)
                  <option  value="{{ $row->id }}">{{ $row->name}}</option>
              @endforeach
            </select>
          </div>
          <div class="col-12">
              <label class="form-label">Name</label>
              <input type="text" class="form-control" name="name" value="{{$store->name}}">
          </div>
          <div class="col-12">
            <label class="form-label">Url</label>
            <input type="text" class="form-control" name="url" value="{{$store->url}}">
          </div>
          <div class="col-12">
            <label class="form-label">Description</label>
            <textarea class="form-control" name="description">{{$store->description}}</textarea>
              
          </div>
          <div class="col-12">
            <label class="form-label">Blog Description</label>
            <textarea class="form-control" name="blog_description">{{$store->blog_description}}</textarea>
              
          </div>
          <div class="col-12">
            <label class="form-label">Meta Title</label>
            <input type="text" class="form-control" name="meta_title" value="{{$store->meta_title}}">
             
          </div>
          <div class="col-12">
            <label class="form-label">Meta Description</label>
            <textarea class="form-control" name="meta_description">{{$store->meta_description}}</textarea>
             
          </div>
          <div class="col-12">
            <label class="form-label">Featured Image</label>
            <input type="file" class="form-control" name="featured_image">
            <img src="{{asset('public/assets/images/stores')}}/{{$store->feature_image}}" alt="" width="100">
          </div>
          <div class="col-12">
            <div class="d-grid">
              <button type="submit" class="btn btn-primary">Save</button>
            </div>
          </div>
          {!! Form::close() !!}
        </div>
        </div>
      </div>
    </div>
  </div>
@endsection
@section('script')
<script src="{{ asset('public/assets/plugins/select2/js/select2.min.js') }}"></script>
    <script src="{{ asset('public/assets/js/form-select2.js') }}"></script>
@endsection