
@extends('admin.layout.master')

@section('content')

<!--start breadcrumb-->
<div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
    <div class="breadcrumb-title pe-3">Settings</div>
    <div class="ps-3">
      <nav aria-label="breadcrumb">
        <ol class="breadcrumb mb-0 p-0 align-items-center">
          <li class="breadcrumb-item"><a href="javascript:;"><ion-icon name="home-outline"></ion-icon></a>
          </li>
          <li class="breadcrumb-item active" aria-current="page">Social Media</li>
        </ol>
      </nav>
    </div>
    <div class="ms-auto">
        <div class="btn-group">
          <a href="{{route('social.media')}}" class="btn btn-outline-primary">Back to list</a>
        </div>
      </div>
  </div>
  <!--end breadcrumb-->


  <div class="row">
    <div class="col-xl-12">
        @if(Session::has('success'))
        <div class="alert alert-success">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            {{ Session::get('success') }}
            @php
                Session::forget('success');
            @endphp
        </div>
        @elseif(Session::has('error'))
        <div class="alert alert-danger">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            {{ Session::get('error') }}
            @php
                Session::forget('error');
            @endphp
        </div>
        @endif
      <div class="card">
        <div class="card-body">
          <div class="border p-3 rounded">
          <h6 class="mb-0 text-uppercase">Social Media</h6>
          <hr>
          <form method="POST" action="{{route('update.social.media')}}" enctype="multipart/form-data">
            @csrf
            
            <input type="hidden" value="{{$socialmedia->id}}" name="id">
            <div class="row">
              <div class="col-12">
                <label class="form-label">Title</label>
                <input type="text" class="form-control" name="title" value="{{$socialmedia->title}}">
              </div>
              <div class="col-12">
                <label class="form-label">Url</label>
                <input type="text" class="form-control" name="url" value="{{$socialmedia->url}}">
              </div>
              <div class="col-12">
                <label class="form-label">Icon</label>
                <select name="icon" class="form-control">
                    <option value="{{$socialmedia->icon}}">{{$socialmedia->icon}}</option>
                  <option value="">--Select Icon--</option>
                   <option value="fab fa-facebook">fab fa-facebook</option>
                  <option value="fab fa-twitter">fab fa-twitter</option>
                  <option value="fab fa-instagram">fab fa-instagram</option>
                  <option value="fab fa-google-plus">fab fa-google-plus</option>
                  <option value="fab fa-pinterest">fab fa-pinterest</option>
                  <option value="fab fa-linkedin">fab fa-linkedin</option>
                  <option value="fab fa-youtube">fab fa-youtube</option>
                </select>
              </div>
            </div>
            <br>
            <div class="col-12">
              <div class="d-grid">
                <button type="submit" class="btn btn-primary">Save</button>
              </div>
            </div>
          </form>
        </div>
        </div>
      </div>
    </div>
  </div>
@endsection
