<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Category;
use Str;

class CategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $categories = Category::all();
    	return view('admin.pages.categories.category-list',compact('categories'));
        
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        return view('admin.pages.categories.add-category');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $category = new Category;

    	if($request->hasFile('featured_image')){

    		$featuredfile = $request->file('featured_image');
	    	$featuredimage = uniqid().'.'.$featuredfile->guessExtension();
	    	$image_path = $featuredfile->move(public_path().'/assets/images/categories/',$featuredimage);
	    	$category->feature_image = $featuredimage;

        }
        if($request->hasFile('logo_image')){

    		$logofile = $request->file('logo_image');
	    	$logoimage = uniqid().'.'.$logofile->guessExtension();
	    	$image_path = $logofile->move(public_path().'/assets/images/categories/',$logoimage);
	    	$category->logo_image = $logoimage;

        }
	    	$category->name = $request->name;
	    	$category->slug = Str::slug($request->name);
	    	$category->meta_title = $request->meta_title;
	    	$category->meta_description = $request->meta_description;

	    	if( $category->save() ){
	    		return back()->with('success','Category Added Successfully');
	    	}
	    	else{
	    		return back()->with('error','Something went wrong!');
	    	}
	   
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
        $category = Category::where('id',$id)->first();
    	return view('admin.pages.categories.edit-category',compact('category'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
        $category =  Category::find($id);

    	if($request->hasFile('featured_image')){

    		$featuredfile = $request->file('featured_image');
	    	$featuredimage = uniqid().'.'.$featuredfile->guessExtension();
	    	$image_path = $featuredfile->move(public_path().'/assets/images/categories/',$featuredimage);
	    	$category->feature_image = $featuredimage;

        }
        if($request->hasFile('logo_image')){

    		$logofile = $request->file('logo_image');
	    	$logoimage = uniqid().'.'.$logofile->guessExtension();
	    	$image_path = $logofile->move(public_path().'/assets/images/categories/',$logoimage);
	    	$category->feature_image = $logoimage;

        }
	    	$category->name = $request->name;
	    	$category->slug = Str::slug($request->name);
	    	$category->meta_title = $request->meta_title;
	    	$category->meta_description = $request->meta_description;

	    	if( $category->update() ){
	    		return back()->with('success','Category Updated Successfully');
	    	}
	    	else{
	    		return back()->with('error','Something went wrong!');
	    	}
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        $category = Category::find($id);
        if($category->delete())
        {
           
        return back()->with('success', 'Category deleted successfully.');

        }
        else{
        return back()->with('error', 'Something went wrong!');

        }
    }
}
