<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Category;
use App\Models\Blog;
use Str;

class BlogController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $blogs = Blog::Orderby('updated_at')->get();
        return view('admin.pages.blogs.blog-list',compact('blogs'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        $categories = Category::all();
        return view('admin.pages.blogs.add-blog',compact('categories'));

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        
        $blog = new Blog;

    	if($request->hasFile('featured_image')){
    		$file = $request->file('featured_image');
    		$image = uniqid().'.'.$file->guessExtension();
    		$image_path = $file->move(public_path().'/assets/images/blogs/',$image);
    		$blog->feature_image = $image;

        }    
    		$blog->category_id = $request->category_id;
    		$blog->title = $request->name;
    		$blog->type = $request->type;
    		$blog->slug = Str::slug($request->name);
    		$blog->description = $request->description;
            $blog->meta_title = $request->meta_title;
            $blog->meta_description = $request->meta_description;
            // dd($blog);
    		if( $blog->save() ){
    			return redirect()->route('blogs.index')->with('success','Blog Added Successfully!');
    		}
    		else{
    			return redirect()->back()->with('error','Something went wrong!');
    		}
    	
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
        $blog = Blog::Select('blogs.*','categories.name as category')
        ->leftjoin('categories','categories.id','blogs.category_id')->where('blogs.id',$id)->first();
        $categories = Category::all();
        return view('admin.pages.blogs.edit-blog',compact('blog','categories'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
        $blog = Blog::find($id);

    	if($request->hasFile('featured_image')){
    		$file = $request->file('featured_image');
    		$image = uniqid().'.'.$file->guessExtension();
    		$image_path = $file->move(public_path().'/assets/images/blogs/',$image);
    		$blog->feature_image = $image;

        }    
    		$blog->category_id = $request->category_id;
    		$blog->title = $request->name;
    		$blog->type = $request->type;
    		$blog->slug = Str::slug($request->name);
    		$blog->description = $request->description;
            $blog->meta_title = $request->meta_title;
            $blog->meta_description = $request->meta_description;

    		if( $blog->update() ){
    			return redirect()->route('blogs.index')->with('success','Blog Updated Successfully!');
    		}
    		else{
    			return redirect()->back()->with('error','Something went wrong!');
    		}
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        $blog = Blog::find($id);
        if($blog->delete())
        {
           
        return back()->with('success', 'Blog deleted successfully.');

        }
        else{
        return back()->with('error', 'Something went wrong!');

        }
    }
}
