<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Banner;
use Str;

class BannerController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $banners = Banner::all();
    	return view('admin.pages.banners.banner-list',compact('banners'));
        
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        return view('admin.pages.banners.add-banner');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $banner = new Banner;

    	if($request->hasFile('featured_image')){

    		$featuredfile = $request->file('featured_image');
	    	$featuredimage = uniqid().'.'.$featuredfile->guessExtension();
	    	$image_path = $featuredfile->move(public_path().'/assets/images/banners/',$featuredimage);
	    	$banner->feature_image = $featuredimage;

        }
        
	    	$banner->name = $request->name;
	    	if( $banner->save() ){
	    		return back()->with('success','Banner Added Successfully');
	    	}
	    	else{
	    		return back()->with('error','Something went wrong!');
	    	}
	   
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
        $banner = Banner::where('id',$id)->first();
    	return view('admin.pages.banners.edit-banner',compact('banner'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
        $banner =  Banner::find($id);

    	if($request->hasFile('featured_image')){

    		$featuredfile = $request->file('featured_image');
	    	$featuredimage = uniqid().'.'.$featuredfile->guessExtension();
	    	$image_path = $featuredfile->move(public_path().'/assets/images/banners/',$featuredimage);
	    	$banner->feature_image = $featuredimage;

        }
        
	    	$banner->name = $request->name;
	    	if( $banner->update() ){
	    		return back()->with('success','Banner Updated Successfully');
	    	}
	    	else{
	    		return back()->with('error','Something went wrong!');
	    	}
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        $banner = Banner::find($id);
        if($banner->delete())
        {
           
        return back()->with('success', 'Banner deleted successfully.');

        }
        else{
        return back()->with('error', 'Something went wrong!');

        }
    }
}
