

<?php $__env->startSection('content'); ?>

<!--start breadcrumb-->
<div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
    <div class="breadcrumb-title pe-3">Users</div>
    <div class="ps-3">
      <nav aria-label="breadcrumb">
        <ol class="breadcrumb mb-0 p-0 align-items-center">
          <li class="breadcrumb-item"><a href="javascript:;"><ion-icon name="home-outline"></ion-icon></a>
          </li>
          <li class="breadcrumb-item active" aria-current="page">Change Password</li>
        </ol>
      </nav>
    </div>
    <div class="ms-auto">
      <div class="btn-group">
        <a href="<?php echo e(route('users.index')); ?>" class="btn btn-outline-primary">Back to List</a>
      </div>
    </div>
  </div>
  <!--end breadcrumb-->


  <div class="row">
    <div class="col-xl-8 mx-auto">
        <?php if(Session::has('success')): ?>
        <div class="alert alert-success">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <?php echo e(Session::get('success')); ?>

            <?php
                Session::forget('success');
            ?>
        </div>
        <?php elseif(Session::has('error')): ?>
        <div class="alert alert-danger">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <?php echo e(Session::get('error')); ?>

            <?php
                Session::forget('error');
            ?>
        </div>
        <?php endif; ?>
      <div class="card">
        <div class="card-body">
          <div class="border p-3 rounded">
          <h6 class="mb-0 text-uppercase">Change Password</h6>
          <hr>
          <form method="POST" action="<?php echo e(route('update.password')); ?>">
            <?php echo csrf_field(); ?>
            <input type="hidden" value="<?php echo e($user->id); ?>" name="id"/>
            <div class="col-12">
              <label class="form-label">Old Password</label>
              <input type="password" class="form-control" name="old_password" value="<?php echo e(old('old_password')); ?>">
                <?php if($errors->has('old_password')): ?>
                    <span class="text-danger"><?php echo e($errors->first('old_password')); ?></span>
                <?php endif; ?>
                
            </div>
            <div class="col-12">
              <label class="form-label">New Password</label>
              <input type="password" class="form-control" name="new_password" value="<?php echo e(old('new_password')); ?>">
                <?php if($errors->has('new_password')): ?>
                    <span class="text-danger"><?php echo e($errors->first('new_password')); ?></span>
                <?php endif; ?>
                <span class="help-block"> Your password must be more than 8 characters long, should contain at-least 1 Uppercase, 1 Lowercase, 1 Numeric and 1 special character. </span>
                
            </div>
            <br>
            <div class="col-12">
                <label class="form-label">Confirm Password</label>
                <input type="password" class="form-control" name="c_password" value="<?php echo e(old('c_password')); ?>">
                <?php if($errors->has('c_password')): ?>
                    <span class="text-danger"><?php echo e($errors->first('c_password')); ?></span>
                <?php endif; ?>
            </div>
            <br>
            
            <div class="col-12">
              <div class="d-grid">
                <button type="submit" class="btn btn-primary">Save</button>
              </div>
            </div>
          </form>
        </div>
        </div>
      </div>
    </div>
  </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\akodracoupons\resources\views/admin/pages/change-password.blade.php ENDPATH**/ ?>