


<?php $__env->startSection('content'); ?>

<!--start breadcrumb-->
<div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
    <div class="breadcrumb-title pe-3">Categories</div>
    <div class="ps-3">
      <nav aria-label="breadcrumb">
        <ol class="breadcrumb mb-0 p-0 align-items-center">
          <li class="breadcrumb-item"><a href="javascript:;"><ion-icon name="home-outline"></ion-icon></a>
          </li>
          <li class="breadcrumb-item active" aria-current="page">Edit Category</li>
        </ol>
      </nav>
    </div>
    <div class="ms-auto">
      <div class="btn-group">
        <a href="<?php echo e(route('categories.index')); ?>" class="btn btn-outline-primary">Back to List</a>
      </div>
    </div>
  </div>
  <!--end breadcrumb-->


  <div class="row">
    <div class="col-xl-12">
        <?php if(Session::has('success')): ?>
        <div class="alert alert-success">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <?php echo e(Session::get('success')); ?>

            <?php
                Session::forget('success');
            ?>
        </div>
        <?php elseif(Session::has('error')): ?>
        <div class="alert alert-danger">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <?php echo e(Session::get('error')); ?>

            <?php
                Session::forget('error');
            ?>
        </div>
        <?php endif; ?>
      <div class="card">
        <div class="card-body">
          <div class="border p-3 rounded">
          <h6 class="mb-0 text-uppercase">Edit Category</h6>
          <hr>
          <?php echo Form::model($category, ['method' => 'PATCH','route' => ['categories.update', $category->id] , 'enctype'=> 'multipart/form-data','class' => 'row g-3']); ?>

            <div class="col-12">
              <label class="form-label">Name</label>
              <input type="text" class="form-control" name="name" value="<?php echo e(old('name') ?? $category->name); ?>">
              <?php if($errors->has('name')): ?>
                  <span class="text-danger"><?php echo e($errors->first('name')); ?></span>
              <?php endif; ?>
            </div>
            <div class="col-12">
              <label class="form-label">Meta Title</label>
              <input type="text" class="form-control" name="meta_title" value="<?php echo e(old('meta_title') ?? $category->meta_title); ?>">
                <?php if($errors->has('meta_title')): ?>
                    <span class="text-danger"><?php echo e($errors->first('meta_title')); ?></span>
                <?php endif; ?>
            </div>
            <div class="col-12">
              <label class="form-label">Meta Description</label>
              <textarea class="form-control" name="meta_description"><?php echo e(old('meta_description') ?? $category->meta_description); ?></textarea>
                <?php if($errors->has('meta_description')): ?>
                    <span class="text-danger"><?php echo e($errors->first('meta_description')); ?></span>
                <?php endif; ?>
            </div>
            <div class="col-12">
              <label class="form-label">Featured Image</label>
              <input type="file" class="form-control" name="featured_image">
              <img src="<?php echo e(asset('public/assets/images/categories')); ?>/<?php echo e($category->feature_image); ?>" alt="" width="100">
            </div>
            <div class="col-12">
              <label class="form-label">Logo Image</label>
              <input type="file" class="form-control" name="logo_image">
              <img src="<?php echo e(asset('public/assets/images/categories')); ?>/<?php echo e($category->logo_image); ?>" alt="" width="100">
              
            </div>
            <div class="col-12">
              <div class="d-grid">
                <button type="submit" class="btn btn-primary">Save</button>
              </div>
            </div>
          <?php echo Form::close(); ?>

        </div>
        </div>
      </div>
    </div>
  </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\akodracoupons\resources\views/admin/pages/categories/edit-category.blade.php ENDPATH**/ ?>