@extends('user.layout.master')
@section('meta-content')
@php
$settings = \App\Models\GeneralSetting::find(1);
@endphp
<meta name="csrf-token" content="{{csrf_token()}}" />
<meta name="title" content="@if($settings){{$settings->meta_title}}@endif">
<meta name="description" content="@if($settings){{$settings->meta_description}}@endif">
<meta name="tags" content="@if($settings){{$settings->meta_tags}}@endif">
<meta name="keywords" content="@if($settings){{$settings->meta_keywords}}@endif">
<link rel="canonical" href="{{url('/')}}"/>
@endsection
@section('styles')
<link rel="stylesheet" href="{{asset('public/user-assets/css/bootstrap.min.css')}}">
<link rel="stylesheet" href="{{asset('public/user-assets/css/style.css')}}">
<link rel="stylesheet" href="{{asset('public/user-assets/css/blog.css')}}">
@endsection
@section('content')
<div id="crumbs">
   <div class="container">
      <ul>
         <li><a href="#" class="home"><i class="fa fa-home" aria-hidden="true"></i></a> @if($settings){{$settings->site_title}}@endif</li>
         <li><a href="javascript:void(0);"><i class="fa fa-angle-double-right" aria-hidden="true"></i></a></li>
         <li><a class="active"> {{$category->name}}</a></li>
      </ul>
   </div>
</div>


<main id="main" style="margin-top:-50px">
   <div class="container" id="twocolumns">
        <div id="content">
             <h1 style="font-size:32px"></h1>
            <section class="coupon-area">
                <!--<h1></h1> -->
                @foreach($coupons as $row)
                
                <div class="col-md-4 col-sm-4 col-xs-12 circ_box">
                   <a href="">
                      <div class="circ_img"> 
                         <img class=" up_div_img" src="{{ asset('public/assets/images/stores') }}/{{ $row->store_image }}"> 
                      </div>
                   </a>
                   <div class="inner_c_bx">
                      <p class="in_c_p" style="text-transform:capitalize;">{{$row->title}}</p>
                      <p class="in_c_exp">{{$row->description}}</p>
                      @if($row->code != null)
                      <a href="{{ $row->url }}" target="_blank"  id="coupon-button" data-title="{{ $row->title }}" data-des="{{ $row->description }}" data-codes="{{ $row->code }}" data-url="{{ $row->url }}" data-coupon_id="{{ $row->id }}"  data-img="{{ asset('public/assets/images/stores') }}/{{ $row->store_image }}">
                         <div class="g_cd_circ">
                            <input type="submit" class="btn_cd_circ" value="Get Code">
                         </div>
                      </a>
                      @else    
                      <a href="{{ $row->url }}" target="_blank"  id="coupon-button" data-title="{{ $row->title }}" data-des="{{ $row->description }}" data-codes="{{ $row->code }}" data-url="{{ $row->url }}" data-coupon_id="{{ $row->id }}"  data-img="{{ asset('public/assets/images/stores') }}/{{ $row->store_image }}">
                        <div class="g_cd_circ">
                          <input type="submit" class="btn_cd_circ" value="Get Deal">
                        </div>
                     </a> 
                      @endif    
                    </div>
                </div>
               @endforeach
            </section>
        </div>
        <aside id="sidebar">
      <section class="info-box">
         <header class="head">
            <div class="logo">
               <a href="#"><span><img src="{{asset('public/assets/images/categories')}}/{{$category->logo_image}}"></span></a>
            </div>
          
         </header>
         <div class="text-area">
            <p>
               {{$category->name}}                           
            </p>
         </div>
      </section>
      <nav class="side-nav open-close">
         <h2>
            <a href="#" class="opener"><span>Similar Stores</span></a>
         </h2>
         <div class="slide js-slide-hidden">
            <ul>
               @foreach ($stores as $row)
               <li><a href="{{route('store.profile',$row->slug)}}">{{$row->name}}</a></li>
               @endforeach   
            </ul>
         </div>
      </nav>
   </aside>
   </div>
</main>
@endsection
@section('scripts')
 <script src="{{asset('public/user-assets/js/site.js')}}" type="text/javascript"></script>
 <script src="{{asset('public/user-assets/js/main.js')}}" type="text/javascript"></script>
 
@endsection