@extends('user.layout.master')
@section('meta-content')
    @php
        $settings = \App\Models\GeneralSetting::find(1);
    @endphp
    <meta name="csrf-token" content="{{ csrf_token() }}" />
    <meta name="title" content="@if ($settings) {{ $settings->meta_title }} @endif">
    <meta name="description" content="@if ($settings) {{ $settings->meta_description }} @endif">
    <meta name="tags" content="@if ($settings) {{ $settings->meta_tags }} @endif">
    <meta name="keywords" content="@if ($settings) {{ $settings->meta_keywords }} @endif">
    <link rel="canonical" href="{{ url('/') }}" />
@endsection
@section('content')

<section class="popular_blogs">
   <div class="container">
       <div class="row">
           <div class="col-12">
               <div class="main_heading">
                   <h4><span>Featured Posts</span></h4>
               </div>
               <div class="p_b_main">
                   @foreach ($blogs as $pblog)
                       <a href="{{ route('blog.profile', $pblog->slug) }}" class="p_b_blog">
                           <figure class="p_b_img">
                               <img class="lazy"
                                   data-src="{{ asset('public/assets/images/blogs') }}/{{ $pblog->feature_image }}">
                               <div class="blog_tags">
                                   <div class="tag">{{ $pblog->category }}</div>
                               </div>
                           </figure>
                           <content class="p_b_content">
                               <h4 class="blog_title webkit_box">{{ $pblog->title }}</h4>
                               <p class="blog_desc webkit_box p_b_desc">
                                  
                               </p>

                           </content>
                       </a>
                   @endforeach
               </div>
           </div>
       </div>
   </div>
</section>

@endsection
