@extends('admin.layout.master')
@section('style')
    <link href="{{asset('public/assets/plugins/datatable/css/dataTables.bootstrap5.min.css')}}" rel="stylesheet" />
    <style>
   body.dragging,
    body.dragging * {
    	cursor: grabbing !important;
    }
    .dragged {
    	position: absolute !important;
    	opacity: 0.6;
    	z-index: 2000;
    }
    .handle {
    	cursor: grab;
    }
</style>
  
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.min.css">
@endsection
@section('content')

<!--start breadcrumb-->
<div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
    <div class="breadcrumb-title pe-3">Stores</div>
    <div class="ps-3">
      <nav aria-label="breadcrumb">
        <ol class="breadcrumb mb-0 p-0 align-items-center">
          <li class="breadcrumb-item"><a href="javascript:;"><ion-icon name="home-outline"></ion-icon></a>
          </li>
          <li class="breadcrumb-item active" aria-current="page">Coupons Record</li>
        </ol>
      </nav>
    </div>
    <div class="ms-auto">
        <div class="btn-group">
          <a href="{{route('stores.create')}}" class="btn btn-outline-primary">Add New Store</a>
        </div>
      </div>
  </div>
  <!--end breadcrumb-->
        
        <div class="card">
            <div class="card-body">
                 <ol class="list-unstyled sortable" store_id="{{ request()->segment(count(request()->segments())) }}">
                            <!--<input type="hidden" name="store_id" value="" />-->
                            @php $count = 1; @endphp
                            @foreach($query as $row)
                            <input type="hidden" value="{{ $row->store_id }}" name="store_id"  class="store_id"/>
                            <li class="sort" id="item_{{ $row->id }}" no="{{ $row->id }}" sortingno="{{$row->sorting_order}}">
    							<div class="card mb-1">
    								<div class="card-header p-2">
    									<div class="row form-inline">
    										<div class="col-sm-1"> 
    										    <div class="parent-icon handle">
                                                    <ion-icon name="list"></ion-icon>
                                                </div>
                                            </div>
    										<div class="col-sm-4"> {{ $row->title }} </div>
    										<div class="col-sm-2"></div>
    										<div class="col-sm-2"></div>
    										<div class="col-sm-2"></div>
    										<div class="col-sm-1 text-right">
    											
    										</div>
    									</div>
    								</div>
    							</div>
						    </li>
						    
						    
						    @php $count++; @endphp
                            @endforeach
                        </ol>
                        <button class="btn btn-primary btn-save">Save</button>
            </div>
        </div>
@endsection
@section('script')
<script src="{{ asset('public/assets/js/bs-custom-file-input.js') }}"></script>
<script src="https://ajax.googleapis.com/ajax/libs/jqueryui/1.10.3/jquery-ui.min.js"></script>
  <script>
   $(document).ready(function () {
       var data = '';
  bsCustomFileInput.init();
  $(".sortable").sortable({
//         update: function (event, ui) {
//             data = $(this).sortable('serialize');
//         },
// 		containerSelector: "ul.sortable",
// 		itemSelector: "li.sort",
// 		handle: ".handle",
// 		placeholder:
// 			'<li><div class="card bg-primary text-white mb-1"><div class="card-header">Drop Here</div></div></li>',
// 		distance: 0,
// 		onDrop: function($item) {
// 			$item.attr("style", null).removeClass("dragged");
// 			$("body").removeClass("dragging");
// 		}
	});
	
	$('.btn-save').click(function(){
	    var arr = [];
	    var store_id = $('.store_id').val();
	    var id = $('.sortable').attr('store_id');
	    $(".sortable li").each(function(i,v){
	        arr.push($(this).attr('no')); 
	    });
	    console.log(id);
	    console.log(store_id);
	    console.log(arr);
        // POST to server using $.post or $.ajax
        $.ajax({
        //     headers: {
        //         'X-CSRF-Token': '{{ csrf_token() }}' 
        //   },
            type: 'GET',
            url: '{{ route('update_order') }}',
            dataType:'json',
            data: {item:arr,store_id:store_id},
            success: function(resp){
              
               console.log(resp);
            },
            error: function(resp){
                console.log(resp);
            }
        }); 
	});
});
</script>
<script src="{{asset('public/assets/plugins/datatable/js/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('public/assets/plugins/datatable/js/dataTables.bootstrap5.min.js')}}"></script>
<script src="{{asset('public/assets/js/table-datatable.js')}}"></script>
@endsection