@extends('admin.layout.master')

@section('content')

<!--start breadcrumb-->
<div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
    <div class="breadcrumb-title pe-3">Settings</div>
    <div class="ps-3">
      <nav aria-label="breadcrumb">
        <ol class="breadcrumb mb-0 p-0 align-items-center">
          <li class="breadcrumb-item"><a href="javascript:;"><ion-icon name="home-outline"></ion-icon></a>
          </li>
          <li class="breadcrumb-item active" aria-current="page">General Setting</li>
        </ol>
      </nav>
    </div>
    
  </div>
  <!--end breadcrumb-->


  <div class="row">
    <div class="col-xl-12">
        @if(Session::has('success'))
        <div class="alert alert-success">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            {{ Session::get('success') }}
            @php
                Session::forget('success');
            @endphp
        </div>
        @elseif(Session::has('error'))
        <div class="alert alert-danger">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            {{ Session::get('error') }}
            @php
                Session::forget('error');
            @endphp
        </div>
        @endif
      <div class="card">
        <div class="card-body">
          <div class="border p-3 rounded">
          <h6 class="mb-0 text-uppercase">General Settings</h6>
          <hr>
          <form method="POST" action="@if($generalsettings){{route('update.general.settings')}}@else {{route('store.general.settings')}}@endif" enctype="multipart/form-data">
            @csrf
            <input type="hidden" value="@if($generalsettings){{$generalsettings->id}}@endif" name="id">
            <div class="row">
              <div class="col-6">
                <label class="form-label">Site Title</label>
                <input type="text" class="form-control" name="site_title" value="@if($generalsettings){{$generalsettings->site_title}}@endif">
              </div>
              <div class="col-6">
                <label class="form-label">Meta Title</label>
                <input type="text" class="form-control" name="meta_title" value="@if($generalsettings){{$generalsettings->meta_title}}@endif">
              </div>
            </div>
            <br>
            <div class="row">
              <div class="col-6">
                <label class="form-label">Description</label>
                <textarea class="form-control" name="description">@if($generalsettings){{$generalsettings->description}}@endif</textarea>
              </div>
              <div class="col-6">
                <label class="form-label">Meta Description</label>
                <textarea class="form-control" name="meta_description">@if($generalsettings){{$generalsettings->meta_description}}@endif</textarea>
              </div>
            </div>
            <br>
            <div class="row">
              <div class="col-6">
                <label class="form-label">Meta Keywords</label>
                <input type="text" class="form-control" name="meta_keywords" value="@if($generalsettings){{$generalsettings->meta_keywords}}@endif">
              </div>
              <div class="col-6">
                <label class="form-label">Meta Tags</label>
                <input type="text" class="form-control" name="meta_tags" value="@if($generalsettings){{$generalsettings->meta_tags}}@endif">
              </div>
            </div>
            <br>
            <div class="row">
              <div class="col-8">
                <label class="form-label">Main Logo</label>
                <input type="file" class="form-control" name="main_logo" value="">
                
              </div>
              <div class="col-4">
                @if($generalsettings)<img src="{{asset('public/assets/images/logos')}}/{{$generalsettings->main_logo}}" alt="" width="100">@endif
                
              </div>
            </div>
            <br>
            <div class="row">
              <div class="col-8">
                <label class="form-label">Footer Logo</label>
                <input type="file" class="form-control" name="footer_logo" value="">
              </div>
              <div class="col-4">
                @if($generalsettings)<img src="{{asset('public/assets/images/logos')}}/{{$generalsettings->footer_logo}}" alt="" width="100">@endif
              </div>
            </div>
            <br>
            <div class="row">
              <div class="col-8">
                <label class="form-label">Favicon</label>
                <input type="file" class="form-control" name="favicon" value="">
              </div>
              <div class="col-4">
                @if($generalsettings)<img src="{{asset('public/assets/images/logos')}}/{{$generalsettings->favicon}}" alt="" width="100">@endif
              </div>
            </div>
            <br>
            <div class="row">
              <div class="col-12">
                <label class="form-label">Disclaimer</label>
                <textarea class="form-control" name="disclaimer">@if($generalsettings){{$generalsettings->disclaimer}}@endif</textarea>
              </div>
            </div>
            <br>
            <div class="col-12">
              <div class="d-grid">
                <button type="submit" class="btn btn-primary">Save</button>
              </div>
            </div>
          </form>
        </div>
        </div>
      </div>
    </div>
  </div>
@endsection
