@extends('admin.layout.master')
@section('style')
    <link href="{{ asset('public/assets/plugins/select2/css/select2.min.css') }}" rel="stylesheet" />
    <link href="{{ asset('public/assets/plugins/select2/css/select2-bootstrap4.css') }}" rel="stylesheet" />
@endsection
@section('content')

<!--start breadcrumb-->
<div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
    <div class="breadcrumb-title pe-3">Events</div>
    <div class="ps-3">
      <nav aria-label="breadcrumb">
        <ol class="breadcrumb mb-0 p-0 align-items-center">
          <li class="breadcrumb-item"><a href="javascript:;"><ion-icon name="home-outline"></ion-icon></a>
          </li>
          <li class="breadcrumb-item active" aria-current="page">Edit Events</li>
        </ol>
      </nav>
    </div>
    <div class="ms-auto">
      <div class="btn-group">
        <a href="{{route('events.index')}}" class="btn btn-outline-primary">Back to List</a>
      </div>
    </div>
  </div>
  <!--end breadcrumb-->


  <div class="row">
    <div class="col-xl-12">
        @if(Session::has('success'))
        <div class="alert alert-success">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            {{ Session::get('success') }}
            @php
                Session::forget('success');
            @endphp
        </div>
        @elseif(Session::has('error'))
        <div class="alert alert-danger">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            {{ Session::get('error') }}
            @php
                Session::forget('error');
            @endphp
        </div>
        @endif
      <div class="card">
        <div class="card-body">
          <div class="border p-3 rounded">
          <h6 class="mb-0 text-uppercase">Edit Event</h6>
          <hr>
          {!! Form::model($event, ['method' => 'PATCH','route' => ['events.update', $event->id] , 'enctype'=> 'multipart/form-data','class' => 'row g-3']) !!}
            
            <div class="col-12">
                <label class="form-label">Name</label>
                <input type="text" class="form-control" name="name" value="{{$event->name}}">
                
            </div>
            
            <div class="col-12">
              <label class="form-label">Description</label>
              <textarea class="form-control" name="description">{{$event->description}}</textarea>
                
            </div>
            
            <div class="col-6">
              <label class="form-label">Featured Image</label>
              <input type="file" class="form-control" name="featured_image">
            <img src="{{asset('public/assets/images/events')}}/{{$event->image}}" alt="" width="100">
               
            </div>
            <div class="col-6">
                <label class="form-label">Is Exclusive?</label>
                <div class="form-check">
                    <input class="form-check-input" type="checkbox" value="yes" id="flexCheckDefault" name="is_exclusive" @if($event->is_exclusive == 'yes') checked @endif>
                    <label class="form-check-label" for="flexCheckDefault">Exclusive</label>
                </div>
              </div>
            <div class="col-12">
              <div class="d-grid">
                <button type="submit" class="btn btn-primary">Save</button>
              </div>
            </div>
          {!! Form::close() !!}
        </div>
        </div>
      </div>
    </div>
  </div>
@endsection
@section('script')
<script src="{{ asset('public/assets/plugins/select2/js/select2.min.js') }}"></script>
    <script src="{{ asset('public/assets/js/form-select2.js') }}"></script>
@endsection