
@extends('admin.layout.master')
@section('style')
    <link href="{{ asset('public/assets/plugins/select2/css/select2.min.css') }}" rel="stylesheet" />
    <link href="{{ asset('public/assets/plugins/select2/css/select2-bootstrap4.css') }}" rel="stylesheet" />
@endsection
@section('content')

<!--start breadcrumb-->
<div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
    <div class="breadcrumb-title pe-3">Coupons</div>
    <div class="ps-3">
      <nav aria-label="breadcrumb">
        <ol class="breadcrumb mb-0 p-0 align-items-center">
          <li class="breadcrumb-item"><a href="javascript:;"><ion-icon name="home-outline"></ion-icon></a>
          </li>
          <li class="breadcrumb-item active" aria-current="page">Edit Coupon</li>
        </ol>
      </nav>
    </div>
    <div class="ms-auto">
      <div class="btn-group">
        <a href="{{route('coupons.index')}}" class="btn btn-outline-primary">Back to List</a>
      </div>
    </div>
  </div>
  <!--end breadcrumb-->


  <div class="row">
    <div class="col-xl-12">
        @if(Session::has('success'))
        <div class="alert alert-success">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            {{ Session::get('success') }}
            @php
                Session::forget('success');
            @endphp
        </div>
        @elseif(Session::has('error'))
        <div class="alert alert-danger">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            {{ Session::get('error') }}
            @php
                Session::forget('error');
            @endphp
        </div>
        @endif
      <div class="card">
        <div class="card-body">
          <div class="border p-3 rounded">
          <h6 class="mb-0 text-uppercase">Edit Coupon</h6>
          <hr>
          {!! Form::model($coupon, ['method' => 'PATCH','route' => ['coupons.update', $coupon->id] , 'enctype'=> 'multipart/form-data','class' => 'row g-3']) !!}
          
          <div class="col-12">
            <label class="form-label">Title</label>
            <input type="text" class="form-control" name="title" value="{{$coupon->title}}">
            
        </div>  
        <div class="col-12">
          <label class="form-label">Description</label>
          <textarea class="form-control" name="description">{{$coupon->description}}</textarea>
           
        </div>
          <div class="col-6">
            <label class="form-label">Code</label>
            <input type="text" class="form-control" name="code" value="{{$coupon->code}}">
          </div>
          <div class="col-6">
            <label class="form-label">Type</label>
            <select name="type" class="form-control">
              <option value="{{$coupon->type}}">{{$coupon->type}}</option>
              <option value="">--Select Type--</option>
              <option value="code">Code</option>
                  <option value="deal">Deal</option>
            </select>
          </div>
        
        
          <div class="col-8">
            <label class="form-label">Url</label>
            <input type="text" class="form-control" name="url" value="{{$coupon->url}}">
          </div>
          <div class="col-4">
            <label class="form-label">Total Use</label>
            <input type="text" class="form-control" name="total_use" value="{{$coupon->total_use}}">
          </div>
        
        
        
          <div class="col-6">
            <label class="form-label">Category</label>
            <select class="single-select " name="category_id">
              <option value="{{$coupon->category_id}}">{{$coupon->category}}</option>
              <option value="">--select Category--</option>
              @foreach ($categories as $key => $row)
                  <option  value="{{ $row->id }}">{{ $row->name}}</option>
              @endforeach
            </select>
          </div>
          <div class="col-6">
            <label class="form-label">Stores</label>
            <select class="single-select " name="store_id">
              <option value="{{$coupon->store_id}}">{{$coupon->store_name}}</option>
              <option value="">--select Store--</option>
              @foreach ($stores as $key => $row)
                  <option  value="{{ $row->id }}">{{ $row->name}}</option>
              @endforeach
            </select>
          </div>
       
        
          <div class="col-6">
            <label class="form-label">Start Date</label>
            <input type="text" class="form-control datepicker" name="start_date" value="{{$coupon->start_date}}"/>
          </div>
          <div class="col-6">
            <label class="form-label">End Date</label>
            <input type="text" class="form-control datepicker" name="end_date" value="{{$coupon->end_date}}"/>
          </div>
          <div class="col-6">
            <label class="form-label">Status</label>
            <select name="status" class="form-control">
              <option value="{{$coupon->status}}">
                @if($coupon->status == 0)
                Active
                @else
                De-Active
                @endif
              </option>
              <option value="">--Select Status--</option>
              <option value="0">Active</option>
              <option value="1">De-Active</option>
            </select>
          </div>
          <div class="col-6">
            <label class="form-label">Is Exclusive?</label>
            <div class="form-check">
              <input class="form-check-input" type="checkbox" value="yes" id="flexCheckDefault" name="is_exclusive" @if($coupon->is_exclusive == 'yes') checked @endif>
              <label class="form-check-label" for="flexCheckDefault">Exclusive</label>
            </div>
          </div>
          <div class="col-12">
            <div class="d-grid">
              <button type="submit" class="btn btn-primary">Save</button>
            </div>
          </div>
          {!! Form::close() !!}
        </div>
        </div>
      </div>
    </div>
  </div>
@endsection
@section('script')
<script src="{{ asset('public/assets/plugins/select2/js/select2.min.js') }}"></script>
    <script src="{{ asset('public/assets/js/form-select2.js') }}"></script>
@endsection