
@extends('admin.layout.master')

@section('content')

<!--start breadcrumb-->
<div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
    <div class="breadcrumb-title pe-3">Categories</div>
    <div class="ps-3">
      <nav aria-label="breadcrumb">
        <ol class="breadcrumb mb-0 p-0 align-items-center">
          <li class="breadcrumb-item"><a href="javascript:;"><ion-icon name="home-outline"></ion-icon></a>
          </li>
          <li class="breadcrumb-item active" aria-current="page">Edit Category</li>
        </ol>
      </nav>
    </div>
    <div class="ms-auto">
      <div class="btn-group">
        <a href="{{route('categories.index')}}" class="btn btn-outline-primary">Back to List</a>
      </div>
    </div>
  </div>
  <!--end breadcrumb-->


  <div class="row">
    <div class="col-xl-12">
        @if(Session::has('success'))
        <div class="alert alert-success">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            {{ Session::get('success') }}
            @php
                Session::forget('success');
            @endphp
        </div>
        @elseif(Session::has('error'))
        <div class="alert alert-danger">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            {{ Session::get('error') }}
            @php
                Session::forget('error');
            @endphp
        </div>
        @endif
      <div class="card">
        <div class="card-body">
          <div class="border p-3 rounded">
          <h6 class="mb-0 text-uppercase">Edit Category</h6>
          <hr>
          {!! Form::model($category, ['method' => 'PATCH','route' => ['categories.update', $category->id] , 'enctype'=> 'multipart/form-data','class' => 'row g-3']) !!}
            <div class="col-12">
              <label class="form-label">Name</label>
              <input type="text" class="form-control" name="name" value="{{old('name') ?? $category->name}}">
              @if ($errors->has('name'))
                  <span class="text-danger">{{ $errors->first('name') }}</span>
              @endif
            </div>
            <div class="col-12">
              <label class="form-label">Meta Title</label>
              <input type="text" class="form-control" name="meta_title" value="{{old('meta_title') ?? $category->meta_title}}">
                @if ($errors->has('meta_title'))
                    <span class="text-danger">{{ $errors->first('meta_title') }}</span>
                @endif
            </div>
            <div class="col-12">
              <label class="form-label">Meta Description</label>
              <textarea class="form-control" name="meta_description">{{old('meta_description') ?? $category->meta_description}}</textarea>
                @if ($errors->has('meta_description'))
                    <span class="text-danger">{{ $errors->first('meta_description') }}</span>
                @endif
            </div>
            <div class="col-12">
              <label class="form-label">Featured Image</label>
              <input type="file" class="form-control" name="featured_image">
              <img src="{{asset('public/assets/images/categories')}}/{{$category->feature_image}}" alt="" width="100">
            </div>
            <div class="col-12">
              <label class="form-label">Logo Image</label>
              <input type="file" class="form-control" name="logo_image">
              <img src="{{asset('public/assets/images/categories')}}/{{$category->logo_image}}" alt="" width="100">
              
            </div>
            <div class="col-12">
              <div class="d-grid">
                <button type="submit" class="btn btn-primary">Save</button>
              </div>
            </div>
          {!! Form::close() !!}
        </div>
        </div>
      </div>
    </div>
  </div>
@endsection
