<?php

namespace App\Http\Controllers\Home;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Helpers\myfunctions;
use App\Models\QuerySetting;
use App\Models\SiteContent;
use App\Models\Category;
use App\Models\Banner;
use App\Models\Coupon;
use App\Models\Store;
use App\Models\Blog;
use App\Models\Page;

class HomeController extends Controller
{
    //
    

   
    public function Index(){
        $query = QuerySetting::find(1);

        //stores settings
        if($query->homepage_stores == 'limit()')
        {
            $stores = Store::limit($query->homepage_stores_limit)->get();
        }
        else if($query->homepage_stores == 'inRandomOrder()')
        {
            $stores = Store::inRandomOrder()->get();
        }
        else if($query->homepage_stores == 'inRandomOrder()->limit()')
        {
            $stores = Store::inRandomOrder()->limit($query->homepage_stores_limit)->get();
        }
        else if($query->homepage_stores == 'Orderby()')
        {
            $stores = Store::orderby($query->homepage_stores_orderby_key1,$query->homepage_stores_orderby_key2)->get();
        }
        else if($query->homepage_stores == 'Orderby()->limit()')
        {
            $stores = Store::orderby($query->homepage_stores_orderby_key1,$query->homepage_stores_orderby_key2)->limit($query->homepage_stores_limit)->get();
        }
        else{
            $stores = Store::get();
        }
        

        //categories settings
        if($query->homepage_categories == 'limit()')
        {
            
            $categories = Category::limit($query->homepage_categories_limit)->get();
        }
        else if($query->homepage_categories == 'inRandomOrder()')
        {
            $categories = Category::inRandomOrder()->get();
        }
        else if($query->homepage_categories == 'inRandomOrder()->limit()')
        {
            $categories = Category::inRandomOrder()->limit($query->homepage_categories_limit)->get();
        }
        else if($query->homepage_categories == 'Orderby()')
        {
            $categories = Category::orderby($query->homepage_categories_orderby_key1,$query->homepage_categories_orderby_key2)->get();
        }
        else if($query->homepage_categories == 'Orderby()->limit()')
        {
            $categories = Category::orderby($query->homepage_categories_orderby_key1,$query->homepage_categories_orderby_key2)->limit($query->homepage_categories_limit)->get();
        }
        else{
            $categories = Category::get();
        }

        //coupons settings
        if($query->homepage_coupons == 'limit()')
        {
            
            $coupons = Coupon::Select('coupons.*','categories.feature_image as category_image','stores.feature_image as store_image')
            ->leftjoin('categories','coupons.category_id','categories.id')
            ->leftjoin('stores','coupons.store_id','stores.id')->limit($query->homepage_coupons_limit)->get();
        }
        else if($query->homepage_coupons == 'inRandomOrder()')
        {
            $coupons = Coupon::Select('coupons.*','categories.feature_image as category_image','stores.feature_image as store_image')
            ->leftjoin('categories','coupons.category_id','categories.id')
            ->leftjoin('stores','coupons.store_id','stores.id')->inRandomOrder()->get();
        }
        else if($query->homepage_coupons == 'inRandomOrder()->limit()')
        {
            $coupons = Coupon::Select('coupons.*','categories.feature_image as category_image','stores.feature_image as store_image')
            ->leftjoin('categories','coupons.category_id','categories.id')
            ->leftjoin('stores','coupons.store_id','stores.id')->inRandomOrder()->limit($query->homepage_coupons_limit)->get();
        }
        else if($query->homepage_coupons == 'Orderby()')
        {
            $coupons = Coupon::Select('coupons.*','categories.feature_image as category_image','stores.feature_image as store_image')
            ->leftjoin('categories','coupons.category_id','categories.id')
            ->leftjoin('stores','coupons.store_id','stores.id')->orderby($query->homepage_coupons_orderby_key1,$query->homepage_coupons_orderby_key2)->get();
        }
        else if($query->homepage_coupons == 'Orderby()->limit()')
        {
            $coupons = Coupon::Select('coupons.*','categories.feature_image as category_image','stores.feature_image as store_image')
            ->leftjoin('categories','coupons.category_id','categories.id')
            ->leftjoin('stores','coupons.store_id','stores.id')->orderby($query->homepage_coupons_orderby_key1,$query->homepage_coupons_orderby_key2)->limit($query->homepage_coupons_limit)->get();
        }
        else{
            $coupons = Coupon::Select('coupons.*','categories.feature_image as category_image','stores.feature_image as store_image')
            ->leftjoin('categories','coupons.category_id','categories.id')
            ->leftjoin('stores','coupons.store_id','stores.id')->limit(8)->get();
        }

        $latest_coupons = Coupon::Select('coupons.*','categories.feature_image as category_image','stores.feature_image as store_image')
            ->leftjoin('categories','coupons.category_id','categories.id')
            ->leftjoin('stores','coupons.store_id','stores.id')->orderby('updated_at','desc')->limit(8)->get();
            
        $blogs = Blog::Select('blogs.*','categories.name as category')
                        ->leftjoin('categories','categories.id','blogs.category_id')->inRandomOrder()->limit(4)->get();  
        $latestblogs = Blog::Select('blogs.*','categories.name as category')
                        ->leftjoin('categories','categories.id','blogs.category_id')->inRandomOrder()->limit(6)->where('blogs.type','latest')->get(); 
        $popularblogs = Blog::Select('blogs.*','categories.name as category')
                        ->leftjoin('categories','categories.id','blogs.category_id')->inRandomOrder()->limit(6)->where('blogs.type','popular')->get();  
        $featuredblogs = Blog::Select('blogs.*','categories.name as category')
                        ->leftjoin('categories','categories.id','blogs.category_id')->inRandomOrder()->limit(6)->where('blogs.type','featured')->get();   
        // $banners = Banner::all();   
        $content = SiteContent::orderby('id','desc')->first();
        return view('user.pages.index',compact('stores','coupons','latest_coupons','categories','blogs','latestblogs','popularblogs','featuredblogs','content'));
    }

    public function Stores()
    {
        $stores = Store::orderby('name','asc')->get();
        
        $storesgroup = $stores->reduce(function ($carry, $store) {
    
            // get first letter
            $first_letter = $store['name'][0];
    
            if ( !isset($carry[$first_letter]) ) {
                $carry[$first_letter] = [];
            }
    
            $carry[$first_letter][] = $store;
    
            return $carry;
    
        }, []);
        
        return view('user.pages.stores',compact('stores'))->with('storesgroup',$storesgroup);
    }

    public function StoreProfile($slug)
    {
        $store = Store::Select('stores.*','categories.name as category')
                        ->leftjoin('categories','categories.id','stores.category_id')
                        ->where('stores.slug',$slug)
                        ->first();
        $query = QuerySetting::find(1);
        if($query->storeprofilepage_stores == 'limit()')
        {
            $stores = Store::limit($query->storeprofilepage_stores_limit)->get();
        }
        else if($query->storeprofilepage_stores == 'inRandomOrder()')
        {
            $stores = Store::inRandomOrder()->get();
        }
        else if($query->storeprofilepage_stores == 'inRandomOrder()->limit()')
        {
            $stores = Store::inRandomOrder()->limit($query->storeprofilepage_stores_limit)->get();
        }
        else if($query->storeprofilepage_stores == 'Orderby()')
        {
            $stores = Store::orderby($query->storeprofilepage_stores_orderby_key1,$query->storeprofilepage_stores_orderby_key2)->get();
        }
        else if($query->storeprofilepage_stores == 'Orderby()->limit()')
        {
            $stores = Store::orderby($query->storeprofilepage_stores_orderby_key1,$query->storeprofilepage_stores_orderby_key2)->limit($query->storeprofilepage_stores_limit)->get();
        }
        else{
            $stores = Store::limit(15)->get();
        }

        if($query->storeprofilepage_categories == 'limit()')
        {
            
            $categories = Category::limit($query->storeprofilepage_categories_limit)->get();
        }
        else if($query->storeprofilepage_categories == 'inRandomOrder()')
        {
            $categories = Category::inRandomOrder()->get();
        }
        else if($query->storeprofilepage_categories == 'inRandomOrder()->limit()')
        {
            $categories = Category::inRandomOrder()->limit($query->storeprofilepage_categories_limit)->get();
        }
        else if($query->storeprofilepage_categories == 'Orderby()')
        {
            $categories = Category::orderby($query->storeprofilepage_categories_orderby_key1,$query->storeprofilepage_categories_orderby_key2)->get();
        }
        else if($query->storeprofilepage_categories == 'Orderby()->limit()')
        {
            $categories = Category::orderby($query->storeprofilepage_categories_orderby_key1,$query->storeprofilepage_categories_orderby_key2)->limit($query->storeprofilepage_categories_limit)->get();
        }
        else{
            $categories = Category::limit(5)->get();
        }


        if($query->storeprofilepage_coupons == 'limit()')
        {
            
            $coupons = Coupon::Select('coupons.*','categories.feature_image as category_image','stores.feature_image as store_image')
            ->leftjoin('categories','coupons.category_id','categories.id')
            ->leftjoin('stores','coupons.store_id','stores.id')->where('coupons.store_id',$store->id)->limit($query->storeprofilepage_coupons_limit)->get();
        }
        else if($query->storeprofilepage_coupons == 'inRandomOrder()')
        {
            $coupons = Coupon::Select('coupons.*','categories.feature_image as category_image','stores.feature_image as store_image')
            ->leftjoin('categories','coupons.category_id','categories.id')
            ->leftjoin('stores','coupons.store_id','stores.id')->where('coupons.store_id',$store->id)->inRandomOrder()->get();
        }
        else if($query->storeprofilepage_coupons == 'inRandomOrder()->limit()')
        {
            $coupons = Coupon::Select('coupons.*','categories.feature_image as category_image','stores.feature_image as store_image')
            ->leftjoin('categories','coupons.category_id','categories.id')
            ->leftjoin('stores','coupons.store_id','stores.id')->where('coupons.store_id',$store->id)->inRandomOrder()->limit($query->storeprofilepage_coupons_limit)->get();
        }
        else if($query->storeprofilepage_coupons == 'Orderby()')
        {
            $coupons = Coupon::Select('coupons.*','categories.feature_image as category_image','stores.feature_image as store_image')
            ->leftjoin('categories','coupons.category_id','categories.id')
           ->leftjoin('stores','coupons.store_id','stores.id')->where('coupons.store_id',$store->id)->orderByRaw("CAST($query->storeprofilepage_coupons_orderby_key1 as UNSIGNED) $query->storeprofilepage_coupons_orderby_key2 ")->get();
        }
        else if($query->storeprofilepage_coupons == 'Orderby()->limit()')
        {
            $coupons = Coupon::Select('coupons.*','categories.feature_image as category_image','stores.feature_image as store_image')
            ->leftjoin('categories','coupons.category_id','categories.id')
            ->leftjoin('stores','coupons.store_id','stores.id')->where('coupons.store_id',$store->id)->orderby($query->storeprofilepage_coupons_orderby_key1,$query->storeprofilepage_coupons_orderby_key2)->limit($query->categorypage_coupons_limit)->get();
        }
        else{
            $coupons = Coupon::Select('coupons.*','categories.feature_image as category_image','stores.feature_image as store_image')
            ->leftjoin('categories','coupons.category_id','categories.id')
            ->leftjoin('stores','coupons.store_id','stores.id')->where('coupons.store_id',$store->id)->get();
        }
        return view('user.pages.store-profile',compact('store','stores','categories','coupons'));
    }

    public function Categories()
    {
        $query = QuerySetting::find(1);

        if($query->categorypage_categories == 'limit()')
        {
            
            $categories = Category::limit($query->categorypage_categories_limit)->get();
        }
        else if($query->categorypage_categories == 'paginate()')
        {
            $categories = Category::paginate($query->categorypage_categories_limit);
        }
        else if($query->categorypage_categories == 'inRandomOrder()')
        {
            $categories = Category::inRandomOrder()->get();
        }
        else if($query->categorypage_categories == 'inRandomOrder()->limit()')
        {
            $categories = Category::inRandomOrder()->limit($query->categorypage_categories_limit)->get();
        }
        else if($query->categorypage_categories == 'Orderby()')
        {
            $categories = Category::orderby($query->categorypage_categories_orderby_key1,$query->categorypage_categories_orderby_key2)->get();
        }
        else if($query->categorypage_categories == 'Orderby()->limit()')
        {
            $categories = Category::orderby($query->categorypage_categories_orderby_key1,$query->categorypage_categories_orderby_key2)->limit($query->categorypage_categories_limit)->get();
        }
        else{
            $categories = Category::get();
        }
        return view('user.pages.categories',compact('categories'));
    }

    public function CategoryProfile($slug)
    {
        $category = Category::where('slug',$slug)
                        ->first();
        $query = QuerySetting::find(1);
        if($query->categoryprofilepage_stores == 'limit()')
        {
            $stores = Store::limit($categoryprofilepage_stores_limit)->get();
        }
        else if($query->categoryprofilepage_stores == 'inRandomOrder()')
        {
            $stores = Store::inRandomOrder()->get();
        }
        else if($query->categoryprofilepage_stores == 'inRandomOrder()->limit()')
        {
            $stores = Store::inRandomOrder()->limit($query->categoryprofilepage_stores_limit)->get();
        }
        else if($query->categoryprofilepage_stores == 'Orderby()')
        {
            $stores = Store::orderby($query->categoryprofilepage_stores_orderby_key1,$query->categoryprofilepage_stores_orderby_key2)->get();
        }
        else if($query->categoryprofilepage_stores == 'Orderby()->limit()')
        {
            $stores = Store::orderby($query->categoryprofilepage_stores_orderby_key1,$query->categoryprofilepage_stores_orderby_key2)->limit($query->categoryprofilepage_stores_limit)->get();
        }
        else{
            $stores = Store::limit(15)->get();
        }

        if($query->categoryprofilepage_categories == 'limit()')
        {
            
            $categories = Category::limit($query->categoryprofilepage_categories_limit)->get();
        }
        else if($query->categoryprofilepage_categories == 'inRandomOrder()')
        {
            $categories = Category::inRandomOrder()->get();
        }
        else if($query->categoryprofilepage_categories == 'inRandomOrder()->limit()')
        {
            $categories = Category::inRandomOrder()->limit($query->categoryprofilepage_categories_limit)->get();
        }
        else if($query->categoryprofilepage_categories == 'Orderby()')
        {
            $categories = Category::orderby($query->categoryprofilepage_categories_orderby_key1,$query->categoryprofilepage_categories_orderby_key2)->get();
        }
        else if($query->categoryprofilepage_categories == 'Orderby()->limit()')
        {
            $categories = Category::orderby($query->categoryprofilepage_categories_orderby_key1,$query->categoryprofilepage_categories_orderby_key2)->limit($query->categoryprofilepage_categories_limit)->get();
        }
        else{
            $categories = Category::limit(5)->get();
        }

        if($query->categoryprofilepage_coupons == 'limit()')
        {
            
            $coupons = Coupon::Select('coupons.*','categories.feature_image as category_image','stores.feature_image as store_image')
            ->leftjoin('categories','categories.id','coupons.category_id')
            ->leftjoin('stores','stores.id','coupons.store_id')->where('coupons.category_id',$category->id)->limit($query->categoryprofilepage_coupons_limit)->get();
        }
        else if($query->categoryprofilepage_coupons == 'inRandomOrder()')
        {
            $coupons = Coupon::Select('coupons.*','categories.feature_image as category_image','stores.feature_image as store_image')
            ->leftjoin('categories','categories.id','coupons.category_id')
            ->leftjoin('stores','stores.id','coupons.store_id')->where('coupons.category_id',$category->id)->inRandomOrder()->get();
        }
        else if($query->categoryprofilepage_coupons == 'inRandomOrder()->limit()')
        {
            $coupons = Coupon::Select('coupons.*','categories.feature_image as category_image','stores.feature_image as store_image')
            ->leftjoin('categories','categories.id','coupons.category_id')
            ->leftjoin('stores','stores.id','coupons.store_id')->where('coupons.category_id',$category->id)->inRandomOrder()->limit($query->categoryprofilepage_coupons_limit)->get();
        }
        else if($query->categoryprofilepage_coupons == 'Orderby()')
        {
            $coupons = Coupon::Select('coupons.*','categories.feature_image as category_image','stores.feature_image as store_image')
           ->leftjoin('categories','categories.id','coupons.category_id')
           ->leftjoin('stores','stores.id','coupons.store_id')->where('coupons.category_id',$category->id)->orderby($query->categoryprofilepage_coupons_orderby_key1,$query->categoryprofilepage_coupons_orderby_key2)->get();
        }
        else if($query->categoryprofilepage_coupons == 'Orderby()->limit()')
        {
            $coupons = Coupon::Select('coupons.*','categories.feature_image as category_image','stores.feature_image as store_image')
           ->leftjoin('categories','categories.id','coupons.category_id')
            ->leftjoin('stores','stores.id','coupons.store_id')->where('coupons.category_id',$category->id)->orderby($query->categoryprofilepage_coupons_orderby_key1,$query->categoryprofilepage_coupons_orderby_key2)->limit($query->categoryprofilepage_coupons_limit)->get();
        }
        else{
            $coupons = Coupon::Select('coupons.*','categories.feature_image as category_image','stores.feature_image as store_image')
            ->leftjoin('categories','categories.id','coupons.category_id')
            ->leftjoin('stores','stores.id','coupons.store_id')->where('coupons.category_id',$category->id)->get();
        }
        // dd($coupons);
        return view('user.pages.category-profile',compact('category','stores','categories','coupons'));
    }

    public function Blogs()
    {
        $query = QuerySetting::find(1);

        if($query->blogpage_blogs == 'limit()')
        {
            
            $blogs = Blog::Select('blogs.*','categories.name as category')
                        ->leftjoin('categories','categories.id','blogs.category_id')->limit($query->blogpage_blogs_limit)->get();
        }
        else if($query->blogpage_blogs == 'paginate()')
        {
            $blogs = Blog::Select('blogs.*','categories.name as category')
                        ->leftjoin('categories','categories.id','blogs.category_id')->paginate($query->blogpage_blogs_limit);
        }
        else if($query->blogpage_blogs == 'inRandomOrder()')
        {
            $blogs = Blog::Select('blogs.*','categories.name as category')
                        ->leftjoin('categories','categories.id','blogs.category_id')->inRandomOrder()->get();
        }
        else if($query->blogpage_blogs == 'inRandomOrder()->limit()')
        {
            $blogs = Blog::Select('blogs.*','categories.name as category')
                        ->leftjoin('categories','categories.id','blogs.category_id')->inRandomOrder()->limit($query->blogpage_blogs_limit)->get();
        }
        else if($query->blogpage_blogs == 'Orderby()')
        {
            $blogs = Blog::Select('blogs.*','categories.name as category')
                        ->leftjoin('categories','categories.id','blogs.category_id')->orderby($query->blogpage_blogs_orderby_key1,$query->blogpage_blogs_orderby_key2)->get();
        }
        else if($query->blogpage_blogs == 'Orderby()->limit()')
        {
            $blogs = Blog::Select('blogs.*','categories.name as category')
                        ->leftjoin('categories','categories.id','blogs.category_id')->orderby($query->blogpage_blogs_orderby_key1,$query->blogpage_blogs_orderby_key2)->limit($query->categorypage_categories_limit)->get();
        }
        else{
            $blogs = Blog::Select('blogs.*','categories.name as category')
                        ->leftjoin('categories','categories.id','blogs.category_id')->get();
        }
        return view('user.pages.blogs',compact('blogs')); 
    }

    public function BlogProfile($slug)
    {
        $blog = Blog::where('slug',$slug)->first();
        $popularblogs = Blog::Select('blogs.*','categories.name as category')
                        ->leftjoin('categories','categories.id','blogs.category_id')->inRandomOrder()->limit(8)->where('blogs.type','popular')->get();  
        return view('user.pages.blog-profile',compact('blog','popularblogs'));
    }

    public function Page($slug)
    {
        $page = Page::where('slug',$slug)->first();
        return view('user.pages.page',compact('page'));
    }

    public function getstores(Request $request){
        if(!empty($request->key)){
             
            $stores = Store::where('name','like','%'.$request->key.'%')->get();
            $key = $request->key;
            
            return view('user.pages.autocomplete',compact('stores','key'));
            
        }
    }
    
    


    public function update_coupon_used(Request $request){
        $used = Coupon::where('id',$request->id)->first();
        if(!empty($used)){
            $coupon = Coupon::where('id',$request->id)->update(array('total_use' => intval($used->total_use) + 1));
            
            return response()->json(['data' => $coupon, 'success' => true]);
        }
    }
    
    public function BlogsByCategory($slug)
    {
        $category = Category::where('slug',$slug)->first();
        $categories = Category::get();
        $blogs = Blog::Select('blogs.*','categories.name as category')
                        ->leftjoin('categories','categories.id','blogs.category_id')
                        ->inRandomOrder()
                        ->where('blogs.category_id',$category->id)
                        ->paginate(20); 
                        
        return view('user.pages.blogs-by-category',compact('category','categories','blogs'));                
    }
    
    public function getblogs(Request $request){
        
        if(!empty($request->key)){
             
            $blogs = Blog::where('title','like','%'.$request->key.'%')->get();
            $key = $request->key;
            
            return view('user.pages.autocomplete',compact('blogs','key'));
            
        }
    }
    
    public function search_stores(Request $request){
        if(!empty($request->input('q'))){
            
        $stores = Store::where('name','like','%'.$request->input('q').'%')->orderBy('name', 'asc')->get();

        $storesgroup = $stores->reduce(function ($carry, $store) {
    
            // get first letter
            $first_letter = $store['name'][0];
    
            if ( !isset($carry[$first_letter]) ) {
                $carry[$first_letter] = [];
            }
    
            $carry[$first_letter][] = $store;
    
            return $carry;
    
        }, []);
        }else{
           $stores = Store::orderBy('name', 'asc')->get();

        $storesgroup = $stores->reduce(function ($carry, $store) {
    
            // get first letter
            $first_letter = $store['name'][0];
    
            if ( !isset($carry[$first_letter]) ) {
                $carry[$first_letter] = [];
            }
    
            $carry[$first_letter][] = $store;
    
            return $carry;
    
        }, []);
        }
        return view('user.pages.stores',get_defined_vars());
    }
}

