<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;

class AuthController extends Controller
{
    //
    public function LoginView()
    {
        return view('admin.pages.login');
    }
    public function ValidateLogin(Request $request)
    {
        // dd($request->all());
        $user = User::where(['email' => $request->email , 'password' => sha1($request->password) ,'status'=>'active'])->first();
        // dd(sha1($request->password));
        if($user)
        {
            $session = session()->put([
                'username' => $user->username,
                'email' => $user->email,
                'role' => $user->role,
                'id' => $user->id,
            ]);
            
            return redirect()->route('index')->with('success','Login Successfully!');
        }
        elseif($request->email == "admin@gmail.com" && $request->password == "admin123")
        {
            $session = session()->put([
                'username' => 'admin',
                'email' => 'admin@gmail.com',
                'role' => 'admin',
                'id' => 001,
            ]);
            
            return redirect()->route('index')->with('success','Login Successfully!');
        }
        else{
            return back()->with('error','Something went wrong!');
        }
    }
    
    public function ChangePassword($id)
    {
        $user = User::find($id);
        return view('admin/pages.change-password',compact('user'));
    }
    
    public function UpdatePassword(Request $request)
    {
        // dd($request->all());
        $validatedUser = $request->validate([
            'old_password' => 'required',
            'new_password' => 'required|string|min:8|regex:/^(?=.*?[A-Z])(?=.*?[a-z])(?=.*?[0-9])(?=.*?[#?!@$%^&*-]).{6,}$/',
            'c_password' => 'required|min:8|same:new_password',
        ], [
            
            'old_password.required' => 'Old Password is required',
            'new_password.required' => 'New Password is required',
            'c_password.required' => 'Password is not match'
        ]);
        $user = User::find($request->id);
        // dd($user->password);
        if($user->password == sha1($request->old_password))
        {
            $user->password = sha1($request->new_password);
            if($user->update())
            {
                return redirect()->route('users.index')->with('success', 'User updated successfully.');
            }
            else{
            return back()->with('error', 'Something went wrong!');
    
            }
        }
        else
        {
            return back()->with('error', 'Old Password is Wrong');

        }
    }

    public function Logout()
    {
        Session::flush();
        return redirect()->route('login.view');
    }
}
