<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;

class UserController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        
        $users = User::where('id','!=',session()->get('id'))->where('role','!=','superadmin')->get();
        return view('admin.pages.users.users-list',compact('users'));
       
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        
        return view('admin.pages.users.add-user');
       
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        // dd($request->all());
        $user = new User;
        $validatedUser = $request->validate([
            'username' => 'required',
            'password' => 'required|string|min:8|regex:/^(?=.*?[A-Z])(?=.*?[a-z])(?=.*?[0-9])(?=.*?[#?!@$%^&*-]).{6,}$/',
            'c_password' => 'required|min:8|same:password',
            'email' => 'required|email|unique:users'
        ], [
            'username.required' => 'Name is required',
            'Email.required' => 'Email is required',
            'password.required' => 'Password is required'
        ]);

        
        $user->name = $request->username;
        $user->email = $request->email;
        $user->password = sha1($request->password);
        $user->role = $request->role;
        $user->status = 'active';
        if($user->save())
        {
            
        return redirect()->route('users.index')->with('success', 'User created successfully.');

        }
        else{
        return back()->with('error', 'Something went wrong!');

        }
    
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
       
        $user = User::find($id);
        return view('admin.pages.users.edit-user',compact('user'));
        
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
        $user = User::find($id);
       
        $user->name = $request->username;
        $user->email = $request->email;
        $user->role = $request->role;
        $user->status = $request->status;
        if($user->update())
        {
            
        return redirect()->route('users.index')->with('success', 'User updated successfully.');

        }
        else{
        return back()->with('error', 'Something went wrong!');

        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        $user = User::find($id);
        if($user->delete())
        {
           
        return back()->with('success', 'User deleted successfully.');

        }
        else{
        return back()->with('error', 'Something went wrong!');

        }
    }
}
