<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Category;
use App\Models\Coupon;
use App\Models\Event;
use App\Models\Store;
use Str;

class StoreController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $stores = Store::Select('stores.*','categories.name as category','events.name as event')
        ->leftjoin('categories','categories.id','stores.category_id')
        ->leftjoin('events','events.id','stores.event_id')
                  ->orderby('updated_at','desc')
                  ->get();
        return view('admin.pages.stores.store-list',compact('stores'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        $categories = Category::all();
        $events = Event::all();
        return view('admin.pages.stores.add-store',compact('categories','events'));

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $store = new Store;

    	if($request->hasFile('featured_image')){
    		$file = $request->file('featured_image');
    		$image = uniqid().'.'.$file->guessExtension();
    		$image_path = $file->move(public_path().'/assets/images/stores/',$image);
        
    		$store->category_id = $request->category_id;
    		$store->event_id = $request->event_id;
    		$store->name = $request->name;
    		$store->slug = Str::slug($request->name);
    		$store->description = $request->description;
    		$store->url = $request->url;
    		$store->blog_description = $request->blog_description;
            $store->meta_title = $request->meta_title;
            $store->meta_description = $request->meta_description;
    		$store->feature_image = $image;

    		if( $store->save() ){
    			return redirect()->route('stores.index')->with('success','Store Added Successfully');
    		}
    		else{
    			return back()->with('error','Something went wrong!');
    		}
    	}
    	else{
    		return back()->with('error','Please Upload Store Media!');
    	}
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
        $store = Store::Select('stores.*','categories.name as category','events.name as event')
        ->leftjoin('categories','categories.id','stores.category_id')
        ->leftjoin('events','events.id','stores.event_id')
        ->orderby('updated_at','desc')
        ->where('stores.id',$id)
        ->first();
        $categories = Category::all();
        $events = Event::all();
        return view('admin.pages.stores.edit-store',compact('store','categories','events'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
        $store = Store::find($id);

    	if($request->hasFile('featured_image')){
    		$file = $request->file('featured_image');
    		$image = uniqid().'.'.$file->guessExtension();
    		$image_path = $file->move(public_path().'/assets/images/stores/',$image);
    		$store->feature_image = $image;

        }
    		$store->category_id = $request->category_id;
    		$store->event_id = $request->event_id;
    		$store->name = $request->name;
    		$store->slug = Str::slug($request->name);
    		$store->description = $request->description;
    		$store->url = $request->url;
    		$store->blog_description = $request->blog_description;
            $store->meta_title = $request->meta_title;
            $store->meta_description = $request->meta_description;

    		if( $store->save() ){
    			return redirect()->route('stores.index')->with('success','Store Updated Successfully!');
    		}
    		else{
    			return back()->with('error','Something went wrong!');
    		}
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        $store = Store::find($id);
        if($store->delete())
        {
           
        return back()->with('success', 'Store deleted successfully.');

        }
        else{
        return back()->with('error', 'Something went wrong!');

        }
    }
    
     public function coupons($id){
        //  dd($id);
        $query = Coupon::where('store_id',$id)->orderByRaw("CAST(sorting_order as UNSIGNED) ASC")->get();
        // dd($query);
        return view('admin.pages.stores.coupons',compact('query'));
    }
    
    public function update_order(Request $request){
       
        $query = Coupon::where('store_id',$request->store_id)->orderby('sorting_order','asc')->get();
        //  dd($query);
        $count = 0;
        foreach($request->item as $row){
            // $arr[] = $request->item[$count];
            $coupon = Coupon::where('id',$row)->first();
            $coupon->sorting_order = $count;
            $coupon->save();
            $count++;
        }
       
        // if($coupon){
        //     return response()->json(['data' => $coupon, 'success' => true]);
        // }else{
        //     return response()->json(['data' => null, 'success' => false]);
        // }
        if($coupon)
        {
           
        return back()->with('success', 'Coupons Sorted successfully.');

        }
        else{
        return back()->with('error', 'Something went wrong!');

        }
    }
}
