<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Event;
use Str;

class EventController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $events = Event::orderby('id','desc')->get();
        return view('admin.pages.events.event-list',compact('events'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        return view('admin.pages.events.add-event');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $event = new Event;

    	if($request->hasFile('featured_image')){
    		$file = $request->file('featured_image');
    		$image = uniqid().'.'.$file->guessExtension();
    		$image_path = $file->move(public_path().'/assets/images/events/',$image);
        
    		$event->name = $request->name;
    		$event->slug = Str::slug($request->name);
    		$event->description = $request->description;
            $event->image = $image;
            $event->is_exclusive = $request->is_exclusive;
    		$event->status = 0;

    		if( $event->save() ){
    			return redirect()->route('events.index')->with('success','Event Added Successfully');
    		}
    		else{
    			return back()->with('error','Something went wrong!');
    		}
    	}
    	else{
    		return back()->with('error','Please Upload Store Media!');
    	}
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
        $event = Event::where('id',$id)->first();
        return view('admin.pages.events.edit-event',compact('event'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
        $event =  Event::find($id);

    	if($request->hasFile('featured_image')){
    		$file = $request->file('featured_image');
    		$image = uniqid().'.'.$file->guessExtension();
    		$image_path = $file->move(public_path().'/assets/images/events/',$image);
            $event->image = $image;

        }
    		$event->name = $request->name;
    		$event->slug = Str::slug($request->name);
    		$event->description = $request->description;
            $event->is_exclusive = $request->is_exclusive;

    		if( $event->save() ){
    			return redirect()->route('events.index')->with('success','Event Updated Successfully');
    		}
    		else{
    			return back()->with('error','Something went wrong!');
    		}
    	
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        $event = Event::find($id);
        if($event->delete())
        {
           
        return back()->with('success', 'Event deleted successfully.');

        }
        else{
        return back()->with('error', 'Something went wrong!');

        }
    }
}
